/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "RecordAttribute" })
public final class RecordAttribute extends AbstractUpdatableDBObject implements DBObjectToRecordattribute, RecordattributeToDBObject {

	/**
	 * 
	 */
	private String attributeName;

	/**
	 * 
	 */
	private int ordinal;

	/**
	 * 
	 */
	private UpdatableDBObject preUpdateState;

	/**
	 * 
	 */
	private String recordTypeName;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the RecordAttribute
	 */
	public RecordAttribute ( ) {
		this("", "", -1, ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * Creates the RecordAttribute
	 * 
	 * @param relvarName
	 * @param recordTypeName
	 * @param ordinal
	 * @param attributeName
	 */
	public RecordAttribute (String relvarName, String recordTypeName, int ordinal, String attributeName) {
		this.relvarName = relvarName.toUpperCase();
		this.recordTypeName = recordTypeName.toUpperCase();
		this.ordinal = ordinal;
		this.attributeName = attributeName.toUpperCase();
	}

	/**
	 * Gets attributeName
	 * 
	 * @return attributeName.
	 */
	public final String getAttributeName ( ) {
		return attributeName;
	}

	/**
	 * Gets ordinal
	 * 
	 * @return ordinal.
	 */
	public final int getOrdinal ( ) {
		return ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordattribute#getRecordattributeAttributename()
	 */
	public String getRecordattributeAttributename ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordattribute#getRecordattributeOrdinal()
	 */
	public String getRecordattributeOrdinal ( ) {
		return Integer.toString(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordattribute#getRecordattributeRecordtypename()
	 */
	public String getRecordattributeRecordtypename ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordattribute#getRecordattributeRelvarname()
	 */
	public String getRecordattributeRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Gets recordTypeName
	 * 
	 * @return recordTypeName.
	 */
	public final String getRecordTypeName ( ) {
		return recordTypeName;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets attributeName
	 * 
	 * @param attributeName
	 *            The attributeName to set.
	 */
	public final void setAttributeName (String attributeName) {
		this.attributeName = attributeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordattributeToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	public void setAttributenameFromDB (String attributename) {
		attributeName = attributename.toUpperCase();
	}

	/**
	 * Sets ordinal
	 * 
	 * @param ordinal
	 *            The ordinal to set.
	 */
	public final void setOrdinal (int ordinal) {
		this.ordinal = ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordattributeToDBObject#setOrdinalFromDB(java.lang.String)
	 */
	public void setOrdinalFromDB (String ordinal) {
		this.ordinal = Integer.parseInt(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new RecordAttribute(relvarName, recordTypeName, ordinal, attributeName);
	}

	/**
	 * Sets recordTypeName
	 * 
	 * @param recordTypeName
	 *            The recordTypeName to set.
	 */
	public final void setRecordTypeName (String recordTypeName) {
		this.recordTypeName = recordTypeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordattributeToDBObject#setRecordtypenameFromDB(java.lang.String)
	 */
	public void setRecordtypenameFromDB (String recordtypename) {
		recordTypeName = recordtypename.toUpperCase();
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordattributeToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		relvarName = relvarname.toUpperCase();
	}

}
