/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "RecordType" })
public final class RecordType extends AbstractUpdatableDBObject implements RecordtypeToDBObject, DBObjectToRecordtype {

	/**
	 * 
	 */
	private String fileName;

	/**
	 * 
	 */
	private String indexName;

	/**
	 * 
	 */
	private RecordType preUpdateState;

	/**
	 * 
	 */
	private String recordTypeName;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * 
	 */
	private int storageSpaceID;

	/**
	 * Creates the RecordType
	 * 
	 */
	public RecordType ( ) {
		this("", "", "", "", -1); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
	}

	/**
	 * Creates the RecordType
	 * 
	 * @param relvarName
	 * @param recordTypeName
	 * @param indexName
	 * @param fileName
	 * @param storageSpaceID
	 */
	public RecordType (String relvarName, String recordTypeName, String indexName, String fileName, int storageSpaceID) {
		this.relvarName = relvarName.toUpperCase();
		this.recordTypeName = recordTypeName.toUpperCase();
		this.indexName = indexName.toUpperCase();
		this.fileName = fileName.toUpperCase();
		this.storageSpaceID = storageSpaceID;
	}

	/**
	 * Gets fileName
	 * 
	 * @return fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * Gets indexName
	 * 
	 * @return indexName.
	 */
	public final String getIndexName ( ) {
		return indexName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordtype#getRecordtypeFilename()
	 */
	public String getRecordtypeFilename ( ) {
		return fileName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordtype#getRECORDTYPE_INDEXname()
	 */
	public String getRecordtypeIndexname ( ) {
		return indexName;
	}

	/**
	 * Gets recordTypeName
	 * 
	 * @return recordTypeName.
	 */
	public final String getRecordTypeName ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordtype#getRecordtypeRecordtypename()
	 */
	public String getRecordtypeRecordtypename ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordtype#getRECORDTYPE_RELVARname()
	 */
	public String getRecordtypeRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRecordtype#getRecordtypeStoragespaceid()
	 */
	public String getRecordtypeStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Gets storageSpaceID
	 * 
	 * @return storageSpaceID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/**
	 * Sets fileName
	 * 
	 * @param fileName
	 *            The fileName to set.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordtypeToDBObject#setFilenameFromDB(java.lang.String)
	 */
	public void setFilenameFromDB (String filename) {
		this.fileName = filename.toUpperCase();
	}

	/**
	 * Sets indexName
	 * 
	 * @param indexName
	 *            The indexName to set.
	 */
	public final void setIndexName (String indexName) {
		this.indexName = indexName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordtypeToDBObject#setIndexnameFromDB(java.lang.String)
	 */
	public void setIndexnameFromDB (String indexname) {
		this.indexName = indexname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new RecordType(relvarName, recordTypeName, indexName, fileName, storageSpaceID);
	}

	/**
	 * Sets recordTypeName
	 * 
	 * @param recordTypeName
	 *            The recordTypeName to set.
	 */
	public final void setRecordTypeName (String recordTypeName) {
		this.recordTypeName = recordTypeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordtypeToDBObject#setRecordtypenameFromDB(java.lang.String)
	 */
	public void setRecordtypenameFromDB (String recordtypename) {
		this.recordTypeName = recordtypename.toUpperCase();
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordtypeToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

	/**
	 * Sets storageSpaceID
	 * 
	 * @param storageSpaceID
	 *            The storageSpaceID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RecordtypeToDBObject#setStoragespaceidFromDB(java.lang.String)
	 */
	public void setStoragespaceidFromDB (String storagespaceid) {
		this.storageSpaceID = Integer.parseInt(storagespaceid);
	}

}
