/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "Relvar" })
public final class Relvar extends AbstractUpdatableDBObject implements DBObjectToRelvar, RelvarToDBObject {

	/**
	 * 
	 */
	private String name;

	/**
	 * 
	 */
	private String predicate;

	/**
	 * 
	 */
	private Relvar preUpdateState;

	/**
	 * Creates the Relvar
	 */
	public Relvar ( ) {
		this("", ""); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * Creates the Relvar
	 * 
	 * @param name
	 * @param predicate
	 */
	public Relvar (String name, String predicate) {
		this.name = name.toUpperCase();
		this.predicate = predicate;
	}

	/**
	 * Gets name
	 * 
	 * @return name.
	 */
	public final String getName ( ) {
		return name;
	}

	/**
	 * Gets predicate
	 * 
	 * @return predicate.
	 */
	public final String getPredicate ( ) {
		return predicate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRelvar#getRelvarRelvarname()
	 */
	@Override
	public String getRelvarRelvarname ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRelvar#getRelvarRelvarpredicate()
	 */
	@Override
	public String getRelvarRelvarpredicate ( ) {
		return BracketParser.meta(predicate);
	}

	/**
	 * Sets name
	 * 
	 * @param name
	 *            The name to set.
	 */
	public final void setName (String name) {
		this.name = name.toUpperCase();
	}

	/**
	 * Sets predicate
	 * 
	 * @param predicate
	 *            The predicate to set.
	 */
	public final void setPredicate (String predicate) {
		this.predicate = predicate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new Relvar(name, predicate);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RelvarToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.name = relvarname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RelvarToDBObject#setRelvarpredicateFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarpredicateFromDB (String relvarpredicate) {
		try {
			this.predicate = BracketParser.unMeta(relvarpredicate);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}
}
