/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "RelvarAttribute" })
public final class RelvarAttribute extends AbstractUpdatableDBObject implements DBObjectToRelvarattribute, RelvarattributeToDBObject {

	/**
	 * 
	 */
	private String attributeName;

	/**
	 * 
	 */
	private RelvarAttribute preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the RelvarAttribute
	 */
	public RelvarAttribute ( ) {
		this("", ""); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * Creates the RelvarAttribute
	 * 
	 * @param relvarName
	 * @param attributeName
	 */
	public RelvarAttribute (String relvarName, String attributeName) {
		this.attributeName = attributeName.toUpperCase();
		this.relvarName = relvarName.toUpperCase();
	}

	/**
	 * Gets attributeName
	 * 
	 * @return attributeName.
	 */
	public final String getAttributeName ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRelvarattribute#getRELVARATTRIBUTE_ATTRIBUTEname()
	 */
	@Override
	public String getRelvarattributeAttributename ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToRelvarattribute#getRELVARATTRIBUTE_RELVARname()
	 */
	@Override
	public String getRelvarattributeRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets attributeName
	 * 
	 * @param attributeName
	 *            The attributeName to set.
	 */
	public final void setAttributeName (String attributeName) {
		this.attributeName = attributeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RelvarattributeToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	@Override
	public void setAttributenameFromDB (String attributename) {
		this.attributeName = attributename.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new RelvarAttribute(relvarName, attributeName);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.RelvarattributeToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

}
