/*
 * Created on 24-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
public final class StorageSpace extends AbstractUpdatableDBObject implements DBObjectToStoragespace, StoragespaceToDBObject {

	/**
	 * The extents count
	 */
	private int extentsCount;

	/**
	 * The file name
	 */
	private String fileName;

	/**
	 * The page count
	 */
	private int pageCount;

	/**
	 * The pre-update state
	 */
	private StorageSpace preUpdateState;

	/**
	 * The ID
	 */
	private int storageSpaceID;

	/**
	 * 
	 */
	public StorageSpace ( ) {

	}

	/**
	 * @param fileName
	 *            The file name
	 * @param storageSpaceID
	 *            The ID
	 * @param pageCount
	 *            The page count
	 * @param extentsCount
	 *            The extents count
	 */
	public StorageSpace (String fileName, int storageSpaceID, int pageCount, int extentsCount) {
		this.fileName = fileName.toUpperCase();
		this.pageCount = pageCount;
		this.storageSpaceID = storageSpaceID;
		this.extentsCount = extentsCount;
	}

	/**
	 * Gets extentsCount
	 * 
	 * @return extentsCount.
	 */
	public final int getExtentsCount ( ) {
		return extentsCount;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * Gets The page count
	 * 
	 * @return Returns the pageCount.
	 */
	public final int getPageCount ( ) {
		return pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceExtentscount()
	 */
	@Override
	public String getStoragespaceExtentscount ( ) {
		return Integer.toString(extentsCount);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getStoragespaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/**
	 * Gets The page count
	 * 
	 * @return Returns the pageCount.
	 */
	public final String getStoragespacePagecount ( ) {
		return Integer.toString(pageCount);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getStoragespaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Sets extentsCount
	 * 
	 * @param extentsCount
	 *            The extentsCount to set.
	 */
	public final void setExtentsCount (int extentsCount) {
		this.extentsCount = extentsCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceToDBObject#setExtentscountFromDB(java.lang.String)
	 */
	@Override
	public void setExtentscountFromDB (String extentscount) {
		this.extentsCount = Integer.parseInt(extentscount);
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceToDBObject#setFilenameFromDB(java.lang.String)
	 */
	public void setFilenameFromDB (String x) {
		try {
			this.fileName = BracketParser.unMeta(x).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new IllegalArgumentException(x);
		} catch (MissingEscapedCharacterException e) {
			throw new IllegalArgumentException(x);
		}
	}

	/**
	 * Sets The page count
	 * 
	 * @param pageCount
	 *            The page count.
	 */
	public final void setPageCount (int pageCount) {
		this.pageCount = pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceToDBObject#setPagecountFromDB(java.lang.String)
	 */
	public void setPagecountFromDB (String x) {
		this.pageCount = Integer.parseInt(x);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new StorageSpace(fileName, pageCount, storageSpaceID, extentsCount);
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceToDBObject#setStoragespaceidFromDB(java.lang.String)
	 */
	public final void setStoragespaceidFromDB (String x) {
		this.storageSpaceID = Integer.parseInt(x);
	}
}