/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
@Deprecated
public final class TransactionConstraint extends AbstractUpdatableDBObject implements TransactionconstraintToDBObject, DBObjectToTransactionconstraint, ConstraintmessagetextToDBObject, DBObjectToConstraintmessagetext {

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private String expression;

	/**
	 * 
	 */
	private String label;

	/**
	 * 
	 */
	private String messageText;

	/**
	 * 
	 */
	private int operationType;

	/**
	 * 
	 */
	private TransactionConstraint preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the TransactionConstraint
	 * 
	 */
	public TransactionConstraint ( ) {
		this("", -1, -1, "", "", null); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/**
	 * Creates the TransactionConstraint
	 * 
	 * @param relvarName
	 * @param operationType
	 * @param errorCode
	 * @param expression
	 * @param label
	 * @param messageText
	 */
	public TransactionConstraint (String relvarName, int operationType, long errorCode, String expression, String label, String messageText) {
		this.relvarName = relvarName.toUpperCase();
		this.operationType = operationType;
		this.errorCode = errorCode;
		this.expression = expression;
		this.label = label;
		this.messageText = messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextConstraintmessagetext()
	 */
	@Override
	public String getConstraintmessagetextConstraintmessagetext ( ) {
		return BracketParser.meta(messageText);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextErrorcode()
	 */
	@Override
	public String getConstraintmessagetextErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/**
	 * Gets errorCode
	 * 
	 * @return errorCode.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/**
	 * Gets expression
	 * 
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/**
	 * Gets label
	 * 
	 * @return label.
	 */
	public final String getLabel ( ) {
		return label;
	}

	/**
	 * Gets messageText
	 * 
	 * @return messageText.
	 */
	public final String getMessageText ( ) {
		return messageText;
	}

	/**
	 * Gets operationType
	 * 
	 * @return operationType.
	 */
	public final int getOperationType ( ) {
		return operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTransactionconstraint#getTransactionconstraintConstraintexpression()
	 */
	@Override
	public String getTransactionconstraintConstraintexpression ( ) {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTransactionconstraint#getTransactionconstraintConstraintlabel()
	 */
	@Override
	public String getTransactionconstraintConstraintlabel ( ) {
		return BracketParser.meta(label);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTransactionconstraint#getTransactionconstraintErrorcode()
	 */
	@Override
	public String getTransactionconstraintErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTransactionconstraint#getTransactionconstraintOperationtype()
	 */
	@Override
	public String getTransactionconstraintOperationtype ( ) {
		return Integer.toString(operationType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTransactionconstraint#getTransactionconstraintRelvarname()
	 */
	@Override
	public String getTransactionconstraintRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TransactionconstraintToDBObject#setConstraintexpressionFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintexpressionFromDB (String constraintexpression) {
		try {
			this.expression = BracketParser.unMeta(constraintexpression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TransactionconstraintToDBObject#setConstraintlabelFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintlabelFromDB (String constraintlabel) {
		try {
			this.label = BracketParser.unMeta(constraintlabel);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstraintmessagetextToDBObject#setConstraintmessagetextFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintmessagetextFromDB (String constraintmessagetext) {
		try {
			this.messageText = BracketParser.unMeta(constraintmessagetext);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets errorCode
	 * 
	 * @param errorCode
	 *            The errorCode to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TransactionconstraintToDBObject#setErrorcodeFromDB(java.lang.String)
	 */
	@Override
	public void setErrorcodeFromDB (String errorcode) {
		this.errorCode = Long.parseLong(errorcode);
	}

	/**
	 * Sets expression
	 * 
	 * @param expression
	 *            The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/**
	 * Sets label
	 * 
	 * @param label
	 *            The label to set.
	 */
	public final void setLabel (String label) {
		this.label = label;
	}

	/**
	 * Sets messageText
	 * 
	 * @param messageText
	 *            The messageText to set.
	 */
	public final void setMessageText (String messageText) {
		this.messageText = messageText;
	}

	/**
	 * Sets operationType
	 * 
	 * @param operationType
	 *            The operationType to set.
	 */
	public final void setOperationType (int operationType) {
		this.operationType = operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TransactionconstraintToDBObject#setOperationtypeFromDB(java.lang.String)
	 */
	@Override
	public void setOperationtypeFromDB (String operationtype) {
		this.operationType = Integer.parseInt(operationtype);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new TransactionConstraint(relvarName, operationType, errorCode, expression, label, messageText);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TransactionconstraintToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}
}
