/*
 * Created on 24-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "TreeIndexSpace", "StorageSpace" })
public final class TreeIndexSpace extends AbstractUpdatableDBObject implements DBObjectToTreeindexspace, DBObjectToStoragespace, TreeindexspaceToDBObject, StoragespaceToDBObject {

	/**
	 * The extents count
	 */
	private int extentsCount;

	/**
	 * The file name
	 */
	private String fileName;

	/**
	 * The page count
	 */
	private int pageCount;

	/**
	 * The pre-update state
	 */
	private TreeIndexSpace preUpdateState;

	/**
	 * The ID
	 */
	private int storageSpaceID;

	/**
	 * 
	 */
	public TreeIndexSpace ( ) {

	}

	/**
	 * @param fileName
	 *            The file name
	 * @param storageSpaceID
	 *            The ID
	 * @param pageCount
	 *            The page count
	 * @param extentsCount
	 *            The extents count
	 */
	public TreeIndexSpace (String fileName, int storageSpaceID, int pageCount, int extentsCount) {
		this.fileName = fileName.toUpperCase();
		this.storageSpaceID = storageSpaceID;
		this.pageCount = pageCount;
		this.extentsCount = extentsCount;
	}

	/**
	 * @return Returns the extentsCount.
	 */
	public final int getExtentsCount ( ) {
		return extentsCount;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * @return Returns the pageCount.
	 */
	public final int getPageCount ( ) {
		return pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceExtentscount()
	 */
	@Override
	public String getStoragespaceExtentscount ( ) {
		return Integer.toString(extentsCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceFilename()
	 */
	public String getStoragespaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespacePagecount()
	 */
	public String getStoragespacePagecount ( ) {
		return Integer.toString(pageCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceStoragespaceid()
	 */
	public String getStoragespaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getTreeindexspaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getTreeindexspaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * @param extentsCount
	 *            The extentsCount to set.
	 */
	public final void setExtentsCount (int extentsCount) {
		this.extentsCount = extentsCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceextentsToDBObject#setExtentscountFromDB(java.lang.String)
	 */
	public void setExtentscountFromDB (String extentscount) {
		this.extentsCount = Integer.parseInt(extentscount);
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFilenameFromDB (String fileName) {
		try {
			this.fileName = BracketParser.unMeta(fileName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * @param pageCount
	 *            The pageCount to set.
	 */
	public final void setPageCount (int pageCount) {
		this.pageCount = pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.StoragespaceToDBObject#setPagecountFromDB(java.lang.String)
	 */
	public void setPagecountFromDB (String x) {
		this.pageCount = Integer.parseInt(x);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new TreeIndexSpace(fileName, storageSpaceID, pageCount, extentsCount);
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStoragespaceidFromDB (String storageSpaceID) {
		this.storageSpaceID = Integer.parseInt(storageSpaceID);
	}
}