/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "TriggeredDataAction" })
public final class TriggeredDataAction extends AbstractUpdatableDBObject implements DBObjectToTriggereddataaction, TriggereddataactionToDBObject {

	/**
	 * 
	 */
	private String actionName;

	/**
	 * 
	 */
	private boolean bypassAssignmentConstraints;

	/**
	 * 
	 */
	private boolean distinct;

	/**
	 * 
	 */
	private String expression;

	/**
	 * 
	 */
	private int operationType;

	/**
	 * 
	 */
	private TriggeredDataAction preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * 
	 */
	private String targetRelvarName;

	/**
	 * 
	 */
	private int triggeredOperationType;

	/**
	 * Creates the TriggeredDataAction
	 */
	public TriggeredDataAction ( ) {
		this("", "", -1, "", -1, false, true, ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	/**
	 * Creates the TriggeredDataAction
	 * 
	 * @param actionName
	 * @param relvarName
	 * @param operationType
	 * @param targetRelvarName
	 * @param triggeredOperationType
	 * @param bypassAssignmentConstraints
	 * @param distinct
	 * @param expression
	 */
	public TriggeredDataAction (String actionName, String relvarName, int operationType, String targetRelvarName, int triggeredOperationType, boolean bypassAssignmentConstraints, boolean distinct, String expression) {
		this.actionName = actionName.toUpperCase();
		this.relvarName = relvarName.toUpperCase();
		this.operationType = operationType;
		this.targetRelvarName = targetRelvarName.toUpperCase();
		this.triggeredOperationType = triggeredOperationType;
		this.bypassAssignmentConstraints = bypassAssignmentConstraints;
		this.distinct = distinct;
		this.expression = expression;
	}

	/**
	 * Gets actionName
	 * 
	 * @return actionName.
	 */
	public final String getActionName ( ) {
		return actionName;
	}

	/**
	 * Gets expression
	 * 
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/**
	 * Gets operationType
	 * 
	 * @return operationType.
	 */
	public final int getOperationType ( ) {
		return operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Gets targetRelvarName
	 * 
	 * @return targetRelvarName.
	 */
	public final String getTargetRelvarName ( ) {
		return targetRelvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionBypassassgconstraints()
	 */
	public String getTriggereddataactionBypassassgconstraints ( ) {
		return Boolean.toString(bypassAssignmentConstraints);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionDataactionname()
	 */
	@Override
	public String getTriggereddataactionDataactionname ( ) {
		return actionName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionIsdistinct()
	 */
	public String getTriggereddataactionIsdistinct ( ) {
		return Boolean.toString(distinct);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionOperationtype()
	 */
	public String getTriggereddataactionOperationtype ( ) {
		return Integer.toString(operationType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionRelvarname()
	 */
	public String getTriggereddataactionRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionSp_expression()
	 */
	public String getTriggereddataactionSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionTargetrelvarname()
	 */
	public String getTriggereddataactionTargetrelvarname ( ) {
		return targetRelvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTriggereddataaction#getTriggereddataactionTriggeredoperationtype()
	 */
	public String getTriggereddataactionTriggeredoperationtype ( ) {
		return Integer.toString(triggeredOperationType);
	}

	/**
	 * Gets triggeredOperationType
	 * 
	 * @return triggeredOperationType.
	 */
	public final int getTriggeredOperationType ( ) {
		return triggeredOperationType;
	}

	/**
	 * Gets bypassAssignmentConstraints
	 * 
	 * @return bypassAssignmentConstraints.
	 */
	public final boolean isBypassAssignmentConstraints ( ) {
		return bypassAssignmentConstraints;
	}

	/**
	 * Gets distinct
	 * 
	 * @return distinct.
	 */
	public final boolean isDistinct ( ) {
		return distinct;
	}

	/**
	 * Sets actionName
	 * 
	 * @param actionName
	 *            The actionName to set.
	 */
	public final void setActionName (String actionName) {
		this.actionName = actionName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setBypassassgconstraintsFromDB(java.lang.String)
	 */
	public void setBypassassgconstraintsFromDB (String bypassassgconstraints) {
		this.bypassAssignmentConstraints = Boolean.parseBoolean(bypassassgconstraints);
	}

	/**
	 * Sets bypassAssignmentConstraints
	 * 
	 * @param bypassAssignmentConstraints
	 *            The bypassAssignmentConstraints to set.
	 */
	public final void setBypassAssignmentConstraints (boolean bypassAssignmentConstraints) {
		this.bypassAssignmentConstraints = bypassAssignmentConstraints;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setDataactionnameFromDB(java.lang.String)
	 */
	@Override
	public void setDataactionnameFromDB (String dataactionname) {
		this.actionName = dataactionname.toUpperCase();
	}

	/**
	 * Sets distinct
	 * 
	 * @param distinct
	 *            The distinct to set.
	 */
	public final void setDistinct (boolean distinct) {
		this.distinct = distinct;
	}

	/**
	 * Sets expression
	 * 
	 * @param expression
	 *            The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setIsdistinctFromDB(java.lang.String)
	 */
	public void setIsdistinctFromDB (String isdistinct) {
		this.distinct = Boolean.parseBoolean(isdistinct);
	}

	/**
	 * Sets operationType
	 * 
	 * @param operationType
	 *            The operationType to set.
	 */
	public final void setOperationType (int operationType) {
		this.operationType = operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setOperationtypeFromDB(java.lang.String)
	 */
	public void setOperationtypeFromDB (String operationtype) {
		this.operationType = Integer.parseInt(operationtype);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new TriggeredDataAction(actionName, relvarName, operationType, targetRelvarName, triggeredOperationType, bypassAssignmentConstraints, distinct, expression);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		this.expression = sp_expression;
	}

	/**
	 * Sets targetRelvarName
	 * 
	 * @param targetRelvarName
	 *            The targetRelvarName to set.
	 */
	public final void setTargetRelvarName (String targetRelvarName) {
		this.targetRelvarName = targetRelvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setTargetrelvarnameFromDB(java.lang.String)
	 */
	public void setTargetrelvarnameFromDB (String targetrelvarname) {
		this.targetRelvarName = targetrelvarname.toUpperCase();
	}

	/**
	 * Sets triggeredOperationType
	 * 
	 * @param triggeredOperationType
	 *            The triggeredOperationType to set.
	 */
	public final void setTriggeredOperationType (int triggeredOperationType) {
		this.triggeredOperationType = triggeredOperationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TriggereddataactionToDBObject#setTriggeredoperationtypeFromDB(java.lang.String)
	 */
	public void setTriggeredoperationtypeFromDB (String triggeredoperationtype) {
		this.triggeredOperationType = Integer.parseInt(triggeredoperationtype);
	}

}
