/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "TupleConstraint", "ConstraintMessageText" })
public final class TupleConstraint extends AbstractUpdatableDBObject implements DBObjectToTupleconstraint, TupleconstraintToDBObject, DBObjectToConstraintmessagetext, ConstraintmessagetextToDBObject {

	/**
	 * 
	 */
	private String constraintExpression;

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private String messageText;

	/**
	 * 
	 */
	private TupleConstraint preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the TupleConstraint
	 */
	public TupleConstraint ( ) {

	}

	/**
	 * Creates the TupleConstraint
	 * 
	 * @param relvarName
	 * @param errorCode
	 * @param constraintExpression
	 * @param messageText
	 */
	public TupleConstraint (String relvarName, long errorCode, String constraintExpression, String messageText) {
		this.relvarName = relvarName;
		this.errorCode = errorCode;
		this.constraintExpression = constraintExpression;
		this.messageText = messageText;
	}

	/**
	 * Gets constraintExpression
	 * 
	 * @return constraintExpression.
	 */
	public final String getConstraintExpression ( ) {
		return constraintExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextConstraintmessagetext()
	 */
	@Override
	public String getConstraintmessagetextConstraintmessagetext ( ) {
		return BracketParser.meta(messageText);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextErrorcode()
	 */
	@Override
	public String getConstraintmessagetextErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/**
	 * Gets errorCode
	 * 
	 * @return errorCode.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/**
	 * Gets messageText
	 * 
	 * @return messageText.
	 */
	public final String getMessageText ( ) {
		return messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleconstraint#getTupleconstraintConstraintexpression()
	 */
	@Override
	public String getTupleconstraintSp_expression ( ) {
		return BracketParser.meta(constraintExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleconstraint#getTupleconstraintErrorcode()
	 */
	@Override
	public String getTupleconstraintErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleconstraint#getTupleconstraintRelvarname()
	 */
	@Override
	public String getTupleconstraintRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Sets constraintExpression
	 * 
	 * @param constraintExpression
	 *            The constraintExpression to set.
	 */
	public final void setConstraintExpression (String constraintExpression) {
		this.constraintExpression = constraintExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleconstraintToDBObject#setConstraintexpressionFromDB(java.lang.String)
	 */
	@Override
	public void setSp_expressionFromDB (String constraintexpression) {
		try {
			this.constraintExpression = BracketParser.unMeta(constraintexpression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstraintmessagetextToDBObject#setConstraintmessagetextFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintmessagetextFromDB (String constraintmessagetext) {
		try {
			this.messageText = BracketParser.unMeta(constraintmessagetext);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets errorCode
	 * 
	 * @param errorCode
	 *            The errorCode to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleconstraintToDBObject#setErrorcodeFromDB(java.lang.String)
	 */
	@Override
	public void setErrorcodeFromDB (String errorcode) {
		this.errorCode = Long.parseLong(errorcode);
	}

	/**
	 * Sets messageText
	 * 
	 * @param messageText
	 *            The messageText to set.
	 */
	public final void setMessageText (String messageText) {
		this.messageText = messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new TupleConstraint(relvarName, errorCode, constraintExpression, messageText);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleconstraintToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

	/**
	 * Gets a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state. The "smart" update command consists of :
	 * <ul>
	 * <li>optionally (if and only if any changes were applied to the error code or constraintexpression attributes), an update command for the TUPLECONSTRAINT relvar.</li>
	 * <li>optionally (if and only if any changes were applied to the error code or constraint message text), one of the following to update the CONSTRAINTMESSAGETEXT relvar :
	 * <ul>
	 * <li>a DELETE if the preUpdateState message text was non-null and non-empty, but the new message text is null or the empty string.</li>
	 * <li>a INSERT if the preUpdateState message text was null or empty, but the new message text is non-null and a non-empty string.</li>
	 * <li>an UPDATE if the preUpdateState message text was non-null and non-empty, and the new message text is non-null and a non-empty string, and it is the case that either the message text or the error code has changed.</li>
	 * </ul>
	 * </li>
	 * </ul>
	 * 
	 * @return a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state.
	 * @throws NoUpdatesException
	 *             If there are no differences between the pre-update and the current state
	 */
	public DmlAssignmentCommand[] smartUpdateCommand ( ) throws NoUpdatesException {
		DmlAssignmentCommand[] cmds;
		TupleConstraint oldTupleConstraint = (TupleConstraint) getPreUpdateState();
		String oldConstraintMessageText = oldTupleConstraint.messageText;
		final boolean noNewMessageText = messageText == null || messageText.trim().length() == 0;
		final boolean noOldMessageText = oldConstraintMessageText == null || oldConstraintMessageText.trim().length() == 0;

		try {
			DmlUpdateCommand cmd1 = dbUpdateCommand(RELVARNAMES.TUPLECONSTRAINT);
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update TupleConstraint
					cmds = new DmlAssignmentCommand[] { cmd1 };
				} else {
					// now present, update TupleConstraint plus add
					cmds = new DmlAssignmentCommand[] { cmd1, dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update TupleConstraint plus delete
					cmds = new DmlAssignmentCommand[] { cmd1, oldTupleConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				} else {
					// still present, update TupleConstraint plus MessageText
					try {
						cmds = new DmlAssignmentCommand[] { cmd1, dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
					} catch (NoUpdatesException e) {
						cmds = new DmlAssignmentCommand[] { cmd1 };
					}
				}
			}
		} catch (NoUpdatesException e1) {
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update TupleConstraint (which means : nothing to do)
					throw e1;
				} else {
					// now present, update TupleConstraint plus add
					cmds = new DmlAssignmentCommand[] { dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update TupleConstraint plus delete
					cmds = new DmlAssignmentCommand[] { oldTupleConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				} else {
					// still present, update TupleConstraint plus MessageText
					try {
						cmds = new DmlAssignmentCommand[] { dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
					} catch (NoUpdatesException e) {
						throw e1;
					}
				}
			}
		}
		return cmds;
	}
}
