/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
public final class TupleIndex extends AbstractUpdatableDBObject implements TupleindexToDBObject, DBObjectToTupleindex {

	/**
	 * 
	 */
	private String indexName;

	/**
	 * 
	 */
	private TupleIndex preUpdateState;

	/**
	 * 
	 */
	private String recordTypeName;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the TupleIndex
	 * 
	 */
	public TupleIndex ( ) {
		this("", "", ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * Creates the TupleIndex
	 * 
	 * @param relvarName
	 * @param indexName
	 * @param recordTypeName
	 */
	public TupleIndex (String relvarName, String indexName, String recordTypeName) {
		this.relvarName = relvarName.toUpperCase();
		this.indexName = indexName.toUpperCase();
		this.recordTypeName = recordTypeName.toUpperCase();
	}

	/**
	 * Gets indexName
	 * 
	 * @return indexName.
	 */
	public final String getIndexName ( ) {
		return indexName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets recordTypeName
	 * 
	 * @return recordTypeName.
	 */
	public final String getRecordTypeName ( ) {
		return recordTypeName;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTUPLEINDEX_INDEXname()
	 */
	public String getTupleindexIndexname ( ) {
		return indexName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTupleINDEX_RECORDTYPEname()
	 */
	public String getTupleindexRecordtypename ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTupleindexRelvarname()
	 */
	public String getTupleindexRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Sets indexName
	 * 
	 * @param indexName
	 *            The indexName to set.
	 */
	public final void setIndexName (String indexName) {
		this.indexName = indexName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleindexToDBObject#setIndexnameFromDB(java.lang.String)
	 */
	public void setIndexnameFromDB (String indexname) {
		this.indexName = indexname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new TupleIndex(relvarName, indexName, recordTypeName);
	}

	/**
	 * Sets recordTypeName
	 * 
	 * @param recordTypeName
	 *            The recordTypeName to set.
	 */
	public final void setRecordTypeName (String recordTypeName) {
		this.recordTypeName = recordTypeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleindexToDBObject#setRecordtypenameFromDB(java.lang.String)
	 */
	public void setRecordtypenameFromDB (String recordtypename) {
		this.recordTypeName = recordtypename.toUpperCase();
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TupleindexToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

}
