/*
 * Created on 11-nov-2008
 */
package be.SIRAPRISE.client.jsba;


/**
 * The UpdatableDBObject must be implemented by all classes whose objects are to be used as initiators of SIRA_PRISE update commands in the Jave/SIRA_PRISE bridge
 * 
 * @author Erwin Smout
 */
public interface UpdatableDBObject extends DBObject {

	/**
	 * This method is called by the J/R bridging engine after an object has been setup from some tuple retrieved from the database. The method must cause the object to save a copy (/clone) of all the fields that are pertinent to the database. This copy will be retrieved by the J/R bridging engine using the getPreUpdateState() method call, and will subsequently be used by the J/R bridging engine to determine which fields have changed value, and thus to determine which attributes need to be updated in the database.
	 */
	void setPreUpdateState ( );

	/**
	 * Gets The state of the object as it was built by the J/R bridging engine immediately after the object was created from a database tuple (and which should have been set by/using the setPreUpdateState() method.
	 * 
	 * @return The state of the object as it was built by the J/R bridging engine immediately after the object was created from a database tuple (and which should have been set by/using the setPreUpdateState() method.
	 */
	UpdatableDBObject getPreUpdateState ( );

}