/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "VirtualRelvar" })
public final class VirtualRelvar extends AbstractUpdatableDBObject implements DBObjectToVirtualrelvar, VirtualrelvarToDBObject {

	/**
	 * The expression
	 */
	private String expression;

	/**
	 * The pre-update state
	 */
	private VirtualRelvar preUpdateState;

	/**
	 * The constraint label
	 */
	private String relvarName;

	/**
	 * Creates an empty VirtualRelvar
	 */
	public VirtualRelvar ( ) {
		this("", ""); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * Creates the VirtualRelvar
	 * 
	 * @param relvarName
	 *            The constraint label
	 * @param expression
	 *            The expression
	 */
	@ConstructorFor(attributeNames = { "" })
	public VirtualRelvar (String relvarName, String expression) {
		this.expression = expression;
		this.relvarName = relvarName.toUpperCase();
	}

	/**
	 * Gets The expression
	 * 
	 * @return The expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets The constraint label
	 * 
	 * @return The constraint label.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToVirtualrelvar#getVirtualrelvarConstraintlabel()
	 */
	public String getVirtualrelvarRelvarname ( ) {
		return BracketParser.meta(relvarName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToVirtualrelvar#getVirtualrelvarSp_expression()
	 */
	public String getVirtualrelvarSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/**
	 * Sets The expression
	 * 
	 * @param expression
	 *            The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new VirtualRelvar(relvarName, expression);
	}

	/**
	 * Sets The constraint label
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.VirtualrelvarToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarName) {
		try {
			this.relvarName = BracketParser.unMeta(relvarName);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.VirtualrelvarToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		try {
			this.expression = BracketParser.unMeta(sp_expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}
}