/*
 * Created on 27-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The AuthenticationOKMessageType is the type of the message sent by the server in response to a ClientAuthentication message
 * 
 * @author Erwin Smout
 */
public abstract class AuthenticationOKMessageType extends ServerOutputMessageType {

	/**
	 * Creates the instance for some version of a AuthenticationOKMessageType
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	AuthenticationOKMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(ServerMessageTypes.AUTHENTICATIONOK, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Gets an authenticationOK message corresponding to the type/version creating it
	 * 
	 * @return An authenticationOK message corresponding to the type/version creating it
	 */
	public abstract AuthenticationOKMessage message ( );

}
