/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;

import be.SIRAPRISE.client.Version;

/**
 * <P>
 * The AuthenticationOKMessageTypeV1_0 message type has the no fields.
 * </P>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class AuthenticationOKMessageTypeV1_0 extends AuthenticationOKMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new AuthenticationOKMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private AuthenticationOKMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) {
		// There are no specific data items constituting this message type
		return new AuthenticationOKMessageV1_0(this);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) {
		if (!(message instanceof AuthenticationOKMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		// AuthenticationOKMessageV1_0 authenticationOKMessageV1_0 = (AuthenticationOKMessageV1_0)message;
		// There are no specific data items to read

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.AuthenticationOKMessageType#message()
	 */
	public AuthenticationOKMessage message ( ) {
		return new AuthenticationOKMessageV1_0(this);
	}
}
