/*
 * Created on 27-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class ClientAuthenticationMessage extends ServerInputMessage {

	/**
	 * The Identification that the client will give of itself
	 */
	private String clientID;

	/**
	 * The signature computed
	 */
	private byte[] signature;

	/**
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param clientID
	 * @param signature
	 */
	ClientAuthenticationMessage (ClientAuthenticationMessageType type, String clientID, byte[] signature) {
		super(type);
		this.clientID = clientID;
		this.signature = signature;
	}

	/**
	 * Gets The Identification that the client will give of itself
	 * 
	 * @return The Identification that the client will give of itself
	 */
	public String getClientID ( ) {
		return clientID;
	}

	/**
	 * Gets The signature computed
	 * 
	 * @return The signature computed
	 */
	public byte[] getSignature ( ) {
		return signature;
	}

}
