/*
 * Created on 27-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The ClientAuthenticationMessageType is the message type that the server expects the client to send after the server has accepted a connection, and indicated that a signing protocol proposed by the client can be used
 * 
 * @author Erwin Smout
 */
public abstract class ClientAuthenticationMessageType extends ServerInputMessageType {

	/**
     * 
     */
	public static final int MESSAGETYPEID = 0x1815158e;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ClientAuthenticationMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for producing a ClientAuthentication message of this version of the message type
	 * 
	 * @param clientID
	 *            The token identifying the client to the server
	 * @param signature
	 *            The bytes of the signature computed by applying the elected Signature to the clientID field
	 * @return A ClientAuthenticationMessage
	 */
	public abstract ClientAuthenticationMessage message (String clientID, byte[] signature);

}
