/*
 * Created on 27-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * ClientAuthenticationMessageTypeV1_0 is version 1_0 of the ClientAuthenticationMessageType. The layout of this message is as follows.
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>CLIENTID</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the client. This must be a name that appears in some tuple of the CLIENT relvar.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURELENGTH</td>
 * <td>INTEGER</td>
 * <td>2</td>
 * <td>The number of bytes in SIGNATURE.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURE</td>
 * <td>BYTES</td>
 * <td>&nbsp;</td>
 * <td>The actual signature computed by the retained signing algorithm using the client's private key on a message that consists solely of (all the bytes of, i.e. including the TLENGTH and BLENGTH fields) the CLIENTID field.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class ClientAuthenticationMessageTypeV1_0 extends ClientAuthenticationMessageType {

	/**
	 * the instance
	 */
	private static final ClientAuthenticationMessageType instance = new ClientAuthenticationMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ClientAuthenticationMessageType getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private ClientAuthenticationMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		String clientID = MyDataInputStream.getSmallUTFString(in);
		short byteCount = in.readShort();
		byte[] signature = MyDataInputStream.readExactNumberOfBytes(in, byteCount);
		return new ClientAuthenticationMessageV1_0(this, clientID, signature);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ClientAuthenticationMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		ClientAuthenticationMessageV1_0 clientAuthenticationMessageV1_0 = (ClientAuthenticationMessageV1_0) message;

		MyDataOutputStream.writeSmallUTF(clientAuthenticationMessageV1_0.getClientID(), outputStream);
		byte[] signature = clientAuthenticationMessageV1_0.getSignature();
		outputStream.writeShort(signature.length);
		outputStream.write(signature);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.messages.ClientAuthenticationMessageType#message(java.lang.String, byte[])
	 */
	public ClientAuthenticationMessage message (String clientID, byte[] signature) {
		return new ClientAuthenticationMessageV1_0(this, clientID, signature);
	}
}
