/*
 * Created on 24-jul-2008
 */
package be.SIRAPRISE.messages;

import java.util.Set;

import be.SIRAPRISE.client.Version;

/**
 * @author Erwin Smout
 */
public abstract class ClientHelloMessage extends ServerInputMessage {

	/**
	 * The set of encryption protocols that the client is willing and able to use
	 */
	private Set<String> clientCryptoProtocolNames;

	/**
	 * the set of signature protocols that the client is willing and able to use
	 */
	private Set<String> clientSignatureProtocolNames;

	/**
	 * The Version that the client declares to be able to handle
	 */
	private Version clientSiraPriseVersion;

	/**
	 * the idle time requested by the client for this connection
	 */
	private long idleTime;

	/**
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param clientSignatureProtocols
	 *            the set of signature protocols that the client is willing and able to use
	 * @param clientEncryptionProtocols
	 *            The set of encryption protocols that the client is willing and able to use
	 * @param idleTime
	 *            the idle time requested by the client for this connection
	 * @param clientSiraPriseVersion
	 *            the sira_prise version the client issuing the message is designed to handle
	 */
	ClientHelloMessage (ClientHelloMessageType type, Set<String> clientSignatureProtocols, Set<String> clientEncryptionProtocols, long idleTime, Version clientSiraPriseVersion) {
		super(type);
		this.clientSignatureProtocolNames = clientSignatureProtocols;
		this.clientCryptoProtocolNames = clientEncryptionProtocols;
		this.idleTime = idleTime;
		this.clientSiraPriseVersion = clientSiraPriseVersion;
	}

	/**
	 * Gets The set of encryption protocols that the client is willing and able to use
	 * 
	 * @return The set of encryption protocols that the client is willing and able to use
	 */
	public Set<String> getClientCryptoProtocolNames ( ) {
		return clientCryptoProtocolNames;
	}

	/**
	 * Gets the set of signature protocols that the client is willing and able to use
	 * 
	 * @return the set of signature protocols that the client is willing and able to use
	 */
	public Set<String> getClientSignatureProtocolNames ( ) {
		return clientSignatureProtocolNames;
	}

	/**
	 * Gets The Version that the client declares to be able to handle
	 * 
	 * @return The Version that the client declares to be able to handle
	 */
	public Version getClientSiraPriseVersion ( ) {
		return clientSiraPriseVersion;
	}

	/**
	 * Gets the idle time requested by the client for this connection
	 * 
	 * @return the idle time requested by the client for this connection
	 */
	public long getIdleTime ( ) {
		return idleTime;
	}
}
