/*
 * Created on 24-jul-2008
 */
package be.SIRAPRISE.messages;

import java.util.Set;

import be.SIRAPRISE.client.Version;

/**
 * The ClientHelloMessageType groups all versions of the protocol negotiation message ("client hello message")
 * 
 * @author Erwin Smout
 */
public abstract class ClientHelloMessageType extends ServerInputMessageType {

	/**
	 * The numeric identifier for this message type
	 */
	public static final int MESSAGETYPEID = 0xABBAFACE;

	/**
	 * Creates a version of this messagetype
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ClientHelloMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(ClientHelloMessageType.MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for creating instances of ClientHello messages of some particular version of the CLientHello messagetype
	 * 
	 * @param signatureAlgorithmNames
	 *            The set of names of signatrue algorithms that the client is willing and able to use in the conversation with the server
	 * @param encryptionProtocolNames
	 *            The set of names of encryption algorithms that the client is willing and able to use in the conversation with the server
	 * @param requestConnectionIdleTime
	 *            The time in millieseconds that the client requests the server to allow this connection to remain idle, that is, in a state where no transaction has been started on the connection
	 * @param version
	 *            The version of the SIRA_PRISE specification that this client will use in the conversation with the server
	 * @return A ClientHelloMessage
	 */
	public abstract ClientHelloMessage message (Set<String> signatureAlgorithmNames, Set<String> encryptionProtocolNames, long requestConnectionIdleTime, Version version);
}
