/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class CommitRollbackMessage extends ServerInputMessage {

	/**
	 * Flag indicating whether commit is intended rather than rollback
	 */
	private boolean commit;

	/**
	 * The server-side ID of the transaction that requests to be either committed or rolled back. Negative values indicate "the current transaction".
	 */
	private long transactionID;

	/**
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param commit
	 *            flag indicating whether the transaction is to be committed or rolled back
	 * @param transactionID
	 *            The server-side ID of the transaction that requests to be either committed or rolled back. Negative values indicate "the current transaction".
	 */
	CommitRollbackMessage (CommitRollbackMessageType type, boolean commit, long transactionID) {
		super(type);
		this.commit = commit;
		this.transactionID = transactionID;
	}

	/**
	 * Gets the commit flag
	 * 
	 * @return true if commit is intended rather than rollback
	 */
	public final boolean isCommit ( ) {
		return commit;
	}

	/**
	 * Gets The server-side ID of the transaction that requests to be either committed or rolled back. Negative values indicate "the current transaction".
	 * 
	 * @return The server-side ID of the transaction that requests to be either committed or rolled back. Negative values indicate "the current transaction".
	 */
	public final long getTransactionID ( ) {
		return transactionID;
	}

}
