/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The CommitRollbackMessageType is the type of message to be sent by clients when they want the server they're connected to to commit or rollback a (sub)transaction they started.
 * 
 * SIRA_PRISE 1.2 introduced the TRANSACTIONID field in this message type. The default assumed by 1.2 servers when getting this message from 1.1 clients is "the current transaction" (which is the only one such clients have the opportunity to start).
 * 
 * @author Erwin Smout
 */
public abstract class CommitRollbackMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0xC0331188;

	/**
	 * The value for commit
	 */
	static final byte COMMIT = 1;

	/**
	 * The value indicating rollback
	 */
	static final byte ROLLBACK = 0;

	/**
	 * Creates the object representing some version of the CommitRollbackMessageType
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	CommitRollbackMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Gets a CommitRollbackMessage holding the request to either commit or roll back the current transaction
	 * 
	 * @param commit
	 *            true if a commit is requested, false if a rollback is requested
	 * @return a CommitRollbackMessage holding the request to either commit or roll back the current transaction
	 * @deprecated replace with the factory method that includes the identification of the transaction to commit or roll back
	 */
	public final CommitRollbackMessage message (boolean commit) {
		return message(commit, -1);
	}

	/**
	 * Gets a CommitRollbackMessage holding the request to either commit or roll back the transaction with the given ID
	 * 
	 * @param commit
	 *            true if a commit is requested, false if a rollback is requested
	 * @param transactionID
	 *            The server-side ID of the transaction that requests to be committed or rolled back. Negative values indicate "the current transaction".
	 * @return a CommitRollbackMessage holding the request to either commit or roll back the current transaction
	 */
	public abstract CommitRollbackMessage message (boolean commit, long transactionID);

}
