/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * CommitRollbackMessageTypeV1_0 is version 1_0 of the CommitRollbackMessageType. The layout of this message is as follows.
 * 
 * <TABLE BORDER CELLSPACING=1 CELLPADDING=2 WIDTH=100%>
 * <TR>
 * <TH WIDTH="24%" VALIGN="TOP">Zone</TH>
 * <TH WIDTH="12%" VALIGN="TOP">Format</TH>
 * <TH WIDTH="9%" VALIGN="TOP">Length</TH>
 * <TH WIDTH="55%" VALIGN="TOP">Description</TH>
 * </TR>
 * <TR>
 * <TD>COMMIT</TD>
 * <TD>INTEGER</TD>
 * <TD>1</TD>
 * <TD>1 if the transaction is to be committed, 0 if it is to be rolled back.</TD>
 * </TR>
 * </TABLE>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class CommitRollbackMessageTypeV1_0 extends CommitRollbackMessageType {

	/**
	 * the instance
	 */
	private static CommitRollbackMessageType instance = new CommitRollbackMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static CommitRollbackMessageType getInstance ( ) {
		return instance;
	}

	/**
	 */
	private CommitRollbackMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == COMMIT);
		return new CommitRollbackMessageV1_0(this, commit);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof CommitRollbackMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		CommitRollbackMessageV1_0 commitRollbackMessageV1_0 = (CommitRollbackMessageV1_0) message;

		outputStream.writeByte(commitRollbackMessageV1_0.isCommit() ? COMMIT : ROLLBACK);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.CommitRollbackMessageType#message(boolean, long)
	 */
	@Override
	public CommitRollbackMessage message (boolean commit, long transactionID) {
		return new CommitRollbackMessageV1_0(this, commit);
	}
}
