/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * CommitRollbackMessageTypeV1_1 is version 1_1 of the CommitRollbackMessageType. The layout of this message is as follows.
 * 
 * <TABLE BORDER CELLSPACING=1 CELLPADDING=2 WIDTH=100%>
 * <TR>
 * <TH WIDTH="24%" VALIGN="TOP">Zone</TH>
 * <TH WIDTH="12%" VALIGN="TOP">Format</TH>
 * <TH WIDTH="9%" VALIGN="TOP">Length</TH>
 * <TH WIDTH="55%" VALIGN="TOP">Description</TH>
 * </TR>
 * <TR>
 * <TD>COMMIT</TD>
 * <TD>INTEGER</TD>
 * <TD>1</TD>
 * <TD>1 if the transaction is to be committed,<br>
 * 0 if it is to be rolled back.</TD>
 * </TR>
 * <TR>
 * <TD>TRANSACTIONID</TD>
 * <TD>INTEGER</TD>
 * <TD>8</TD>
 * <TD>The server-side ID of the (sub)transaction that must be either committed or rolled back. Negative values indicate "the most recently started transaction".</TD>
 * </TR>
 * </TABLE>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.2
 */
public final class CommitRollbackMessageTypeV1_1 extends CommitRollbackMessageType {

	/**
	 * the instance
	 */
	private static CommitRollbackMessageType instance = new CommitRollbackMessageTypeV1_1();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static CommitRollbackMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private CommitRollbackMessageTypeV1_1 ( ) {
		super(Version.ONE_ONE, Version.ONE_TWO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == COMMIT);
		long transactionID = in.readLong();
		return new CommitRollbackMessageV1_1(this, commit, transactionID);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof CommitRollbackMessageV1_1)) {
			throw new IllegalArgumentException();
		}

		CommitRollbackMessageV1_1 commitRollbackMessageV1_1 = (CommitRollbackMessageV1_1) message;

		outputStream.writeByte(commitRollbackMessageV1_1.isCommit() ? COMMIT : ROLLBACK);
		outputStream.writeLong(commitRollbackMessageV1_1.getTransactionID());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.CommitRollbackMessageType#message(boolean, long)
	 */
	@Override
	public CommitRollbackMessage message (boolean commit, long transactionID) {
		return new CommitRollbackMessageV1_1(this, commit, transactionID);
	}
}
