/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class CommittedMessage extends ServerOutputMessage {

	/**
	 * flag indicating whether a commit has been done by the server
	 */
	private boolean committed;

	/**
	 * @param committed
	 * @param type
	 */
	CommittedMessage (boolean committed, CommittedMessageType type) {
		super(type);
		this.committed = committed;
	}

	/**
	 * Gets the flag indicating whether a commit has been done by the server
	 * 
	 * @return true if the message indicates that a commit has been done by the server
	 */
	public boolean isCommitted ( ) {
		return committed;
	}

}
