/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The Committed message type is the type of message sent by a server in response to a CommitRollback message. It holds an indication of the action undertaken, which might differ from the action requested.
 * 
 * @author Erwin Smout
 */
public abstract class CommittedMessageType extends ServerOutputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0xC03311ED;

	/**
	 * Creates then instance of a version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	CommittedMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting a message of this version of the message type
	 * 
	 * @param commit
	 *            true if the action undertaken was a commit, false if it was a rollback
	 * @return A CommittedMessage of this type
	 */
	public abstract CommittedMessage message (boolean commit);
}
