/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * CommittedMessageTypeV1_0 is version 1_0 of the CommittedMessageType. The layout of this message is as follows.
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>COMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction was committed,<br>
 * 0 if it was rolled back.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class CommittedMessageTypeV1_0 extends CommittedMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new CommittedMessageTypeV1_0();

	/**
	 * gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private CommittedMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == CommitRollbackMessageType.COMMIT);
		return new CommittedMessageV1_0(this, commit);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof CommittedMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		CommittedMessageV1_0 committedMessageV1_0 = (CommittedMessageV1_0) message;

		outputStream.writeByte(committedMessageV1_0.isCommitted() ? CommitRollbackMessageType.COMMIT : CommitRollbackMessageType.ROLLBACK);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.CommittedMessageType#message(boolean)
	 */
	public CommittedMessage message (boolean commit) {
		return new CommittedMessageV1_0(this, commit);
	}

}
