/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public abstract class ConstraintViolatedErrorMessage extends ServerErrorMessage {

	/**
	 * 
	 */
	private static final String errorClass = Messages.getString("ConstraintViolatedErrorMessage.ErrorClassDescription"); //$NON-NLS-1$

	/**
	 * Creates the ErrorMessage object, formatting and setting the appropriate clientResponseText
	 * 
	 * @param type
	 *            this message's type
	 * @param violationMessage
	 *            The server's original violation message
	 * @param errorNumber
	 *            The number identifying the constraint that was violated
	 */
	ConstraintViolatedErrorMessage (ConstraintViolatedErrorMessageType type, String violationMessage, long errorNumber) {
		super(type, errorNumber, MyMessageFormat.format(Messages.getString("ConstraintViolatedErrorMessage.DBExceptionMessage"), new String[] { Long.toString(errorNumber), violationMessage }), violationMessage, false); //$NON-NLS-1$
	}

	public final String getErrorClass ( ) {
		return errorClass;
	}
}