/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The ConstraintViolatedErrorMessageType is the type of message returned by a SIRA_PRISE server to a client when an assignment command carried out by/for that client has resulted in a constraint violation.
 * 
 * @author Erwin Smout
 */
public abstract class ConstraintViolatedErrorMessageType extends ErrorMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0C075124;

	/**
	 * Creates the instance of some version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            Gets the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	ConstraintViolatedErrorMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting a Message of this type holding the given violated-constraint data
	 * 
	 * @param errorcode
	 *            The SIRA_PRISE identification of the constraint that was found violated
	 * @param message
	 *            The (formatted) error message displayed by the server
	 * @return A ConstraintViolatedErrorMessage of the appropriate version reflecting the given errorcode and message
	 */
	public abstract ConstraintViolatedErrorMessage message (long errorcode, String message);
}