/*
 * Created on 5-aug-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * ConstraintViolatedErrorMessageTypeV1_0 is V1_0 of the ConstraintViolatedErrorMessageType. This message has the following fields.
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>ERRORCODE</td>
 * <td>INTEGER</td>
 * <td>8</td>
 * <td>The ERRORCODE identifying which constraint has been violated.</td>
 * </tr>
 * <tr>
 * <td>ERRORMESSAGE</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The error message explaining the detail of the constraint violation that occurred.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class ConstraintViolatedErrorMessageTypeV1_0 extends ConstraintViolatedErrorMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new ConstraintViolatedErrorMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private ConstraintViolatedErrorMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		long constraintID = in.readLong();
		String constraintViolationMessage = MyDataInputStream.getSmallUTFString(in);

		return new ConstraintViolatedErrorMessageV1_0(this, constraintID, constraintViolationMessage);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ConstraintViolatedErrorMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		ConstraintViolatedErrorMessageV1_0 constraintViolatedErrorMessageV1_0 = (ConstraintViolatedErrorMessageV1_0) message;

		outputStream.writeLong(constraintViolatedErrorMessageV1_0.getErrorNumber());
		MyDataOutputStream.writeSmallUTF(constraintViolatedErrorMessageV1_0.getOriginalExceptionMessage(), outputStream);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ConstraintViolatedErrorMessageType#message(long, java.lang.String)
	 */
	public ConstraintViolatedErrorMessage message (long errorcode, String message) {
		return new ConstraintViolatedErrorMessageV1_0(this, errorcode, message);
	}
}