/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.AbstractRelation;

/**
 * @author Erwin Smout
 */
public abstract class DmlExecutedMessage extends ServerOutputMessage {

	/**
	 * The relation holding the executed command's return value, or null if the command executed does not return a relation
	 */
	private AbstractRelation relation;

	/**
	 * @param type
	 */
	DmlExecutedMessage (DmlExecutedMessageType type) {
		super(type);
	}

	/**
	 * @param type
	 * @param relation
	 *            The relation holding the executed command's return value, or null if the command executed does not return a relation
	 */
	DmlExecutedMessage (DmlExecutedMessageType type, AbstractRelation relation) {
		super(type);
		this.relation = relation;
	}

	/**
	 * Gets The relation holding the executed command's return value, or null if the command executed does not return a relation
	 * 
	 * @return The relation holding the executed command's return value, or null if the command executed does not return a relation
	 */
	public AbstractRelation getRelation ( ) {
		return relation;
	}
}
