/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.Version;

/**
 * The DmlExecutedMessageType is the type of message sent by a SIRA_PRISE server in response to an "Execute DML" message
 * 
 * @author Erwin Smout
 */
public abstract class DmlExecutedMessageType extends ServerOutputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0xE5EC01ED;

	/**
	 * Creates the instance of some version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	DmlExecutedMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting the ServerMessage of the appropriate DmlExecuted type holding the relation holding the return values
	 * 
	 * @param relation
	 *            the relation holding the executed command's return values
	 * @return the ServerMessage of the appropriate DmlExecuted type holding the query response
	 */
	public abstract ServerMessage getDmlExecutedMessage (AbstractRelation relation);

}
