/*
 * Created on 4-aug-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.*;
import java.util.Map.Entry;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.InsertionOrderRelation;
import be.SIRAPRISE.client.ClientTuple;
import be.SIRAPRISE.client.DuplicateException;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.TypeDeclaration;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * DmlExecutedMessageTypeV1_0 is V1_0 of the DmlExecutedMessageType.
 * <p>
 * This message has the following fields :
 * </p>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>RESPONSETYPE</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>0 if the dml was an assignment (no further fields will be present), 1 if this message contains a relation value (subsequent fields will be present).</td>
 * </tr>
 * <tr>
 * <td>HEADING</td>
 * <td>HEADING</td>
 * <td>&nbsp;</td>
 * <td>The heading of the relation returned. The HEADING format is defined in the table below.</td>
 * </tr>
 * <tr>
 * <td>TUPLECOUNT</td>
 * <td>INTEGER</td>
 * <td>4</td>
 * <td>The number of tuples that follow. Can be zero. Each tuple is specified as a MARKER field, followed by as many ATTRIBUTEVALUE fields as there are attributes in the heading.</td>
 * </tr>
 * <tr>
 * <td>MARKER</td>
 * <td>INTEGER</td>
 * <td>2</td>
 * <td>Marks the beginning of a tuple value specification. Contains the value x'EEEE'.</td>
 * </tr>
 * <tr>
 * <td>ATTRIBUTEVALUE</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>Appears as many times as there are attributes in the heading, and appears in the order that the attributes were mentioned in the description of the heading.</td>
 * </tr>
 * </tbody>
 * </table>
 * <p>
 * The heading field defines the heading/relation type of the relation returned. It is defined as follows :
 * </p>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>ATTRIBUTECOUNT</td>
 * <td>INTEGER</td>
 * <td>4</td>
 * <td>The number of attributes in the relation heading. This field defines how many times the subsequent ATTRIBUTENAME and TYPENAME field pairs appear. Can be zero.</td>
 * </tr>
 * <tr>
 * <td>ATTRIBUTENAME</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of an attribute in the heading of the relation described.</td>
 * </tr>
 * <tr>
 * <td>TYPENAME</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the type of the attribute named in the preceding field. If the attribute is relation-typed, then the typename is 'RELATION' and the RELATIONTYPE field will be present. If the attribute is scalar, then the RELATIONTYPE field will not be present.</td>
 * </tr>
 * <tr>
 * <td>RELATIONTYPE</td>
 * <td>HEADING</td>
 * <td>&nbsp;</td>
 * <td>Defines the heading/relation type of the nonscalar attribute.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class DmlExecutedMessageTypeV1_0 extends DmlExecutedMessageType {

	/**
	 * the instance
	 */
	private static DmlExecutedMessageType instance = new DmlExecutedMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static DmlExecutedMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private DmlExecutedMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/**
	 * @param in
	 * @param heading
	 * @throws IOException
	 * @throws UTFDataFormatException
	 */
	private void readHeading (DataInputStream in, Heading heading) throws IOException, UTFDataFormatException {
		int degree = in.readInt();
		while (degree-- > 0) {
			String attributeName = MyDataInputStream.getSmallUTFString(in);
			String typeName = MyDataInputStream.getSmallUTFString(in);
			if (typeName.equalsIgnoreCase(TYPENAMES.RELATION)) {
				Heading rvaHeading = new Heading();
				readHeading(in, rvaHeading);
				try {
					heading.add(attributeName, rvaHeading);
				} catch (DuplicateException e) {
					// Assumed to be impossible because this comes from a server
				}
			} else {
				try {
					heading.add(attributeName, typeName);
				} catch (DuplicateException impossible) {
					// Assumed to be impossible because this comes from a server
				}
			}
		}
	}

	// /**
	// * @param in
	// * @param relation
	// * @throws IOException
	// * @throws UTFDataFormatException
	// */
	// private void readRelation(DataInputStream in, Relation relation) throws UTFDataFormatException, IOException {
	// int size = in.readInt();
	// while (size-- > 0) {
	// String attributeName = MyDataInputStream.getSmallUTFString(in);
	// String typeName = MyDataInputStream.getSmallUTFString(in);
	// if (typeName.equalsIgnoreCase(TYPENAMES.RELATION)) { //$NON-NLS-1$
	// CHeading rvaHeading = new CHeading();
	// // readHeading(in, rvaHeading);
	// // heading.add(attributeName, rvaHeading);
	// } else {
	// // heading.add(attributeName, typeName);
	// }
	// }
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		byte b = in.readByte();
		if (b == 0) {
			return new AssignmentExecutedMessageV1_0(this);
		}

		// Else, it's a queryExecutedMessage
		Heading heading = new Heading();
		readHeading(in, heading);

		int count = in.readInt();

		AbstractRelation relation = new InsertionOrderRelation(heading);
		try {
			while (true) {
				in.readShort();
				IntersectableMap<String, String> m = new IntersectableHashMap<String, String>();
				Iterator<Entry<String, TypeDeclaration>> i_heading = heading.entrySet().iterator();
				while (i_heading.hasNext()) {
					m.put(i_heading.next().getKey(), MyDataInputStream.getBigUTFString(in));
				}
				relation.addTupleWithoutHeadingCheck(new ClientTuple(m, heading));
			}
		} catch (EOFException e) {

		}

		if (count != relation.size()) {
			throw new IllegalArgumentException();
		}

		return new QueryExecutedMessageV1_0(relation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {

		// First deal with the special case of AssignmentExecuted
		if (message instanceof AssignmentExecutedMessageV1_0) {
			outputStream.writeByte(0);
		} else {
			if (!(message instanceof QueryExecutedMessageV1_0)) {
				throw new IllegalArgumentException();
			}

			QueryExecutedMessageV1_0 queryExecutedMessageV1_0 = (QueryExecutedMessageV1_0) message;
			AbstractRelation relation = queryExecutedMessageV1_0.getRelation();
			Heading heading = relation.getHeading();

			outputStream.writeByte(1);
			heading.toStream1_0(outputStream);

			outputStream.writeInt(relation.size());
			Iterator<Tuple> i_relation = relation.iterator();
			while (i_relation.hasNext()) {
				outputStream.writeShort(0x0000EEEE);
				AbstractTuple t = (AbstractTuple) i_relation.next();
				Iterator<Entry<String, TypeDeclaration>> i_heading = heading.entrySet().iterator();
				while (i_heading.hasNext()) {
					MyDataOutputStream.writeBigUTF(t.escapedValue(i_heading.next().getKey()), outputStream);
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.DmlExecutedMessageType#getQueryOKMessage(be.erwinsmout.SIRA_PRISE.client.OKResponse)
	 */
	public final ServerMessage getDmlExecutedMessage (AbstractRelation relation) {
		if (relation != null) {
			return new QueryExecutedMessageV1_0(relation);
		} else {
			return new AssignmentExecutedMessageV1_0(this);
		}
	}
}