/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The EndConnectionMessageType is the message type sent by clients to a SIRA_PRISE server when that client wishes to close down and discard a connection it has obtained to the server.
 * 
 * @author Erwin Smout
 */
public abstract class EndConnectionMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0E3DC033;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	EndConnectionMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for creating messages of this version of the type
	 * 
	 * @return An EndConnectionMessage
	 */
	public abstract EndConnectionMessage message ( );

}
