/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class EndTransactionMessage extends ServerInputMessage {

	/**
	 * The flag indicating whether the transaction should be committed prior to ending it
	 */
	private boolean commit;

	/**
	 * The server-side ID of the transaction to be ended. Negative values indicate the "current" transaction, i.e. the lowest nested transaction in the current transaction structure.
	 */
	private long transactionID;

	/**
	 * Creates an EndTransactionMessage holding the given commit indicator and transaction ID
	 * 
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param commit
	 *            Flag indicating whether the transaction is to be committed or rolled back, prior to ending it
	 * @param transactionID
	 *            The server-side ID of the transaction to be ended. Negative values indicate the "current" transaction, i.e. the lowest nested transaction in the current transaction structure.
	 */
	EndTransactionMessage (EndTransactionMessageType type, boolean commit, long transactionID) {
		super(type);
		this.commit = commit;
		this.transactionID = transactionID;
	}

	/**
	 * Gets The server-side ID of the transaction to be ended. Negative values indicate the "current" transaction, i.e. the lowest nested transaction in the current transaction structure.
	 * 
	 * @return The server-side ID of the transaction to be ended. Negative values indicate the "current" transaction, i.e. the lowest nested transaction in the current transaction structure.
	 */
	public final long getTransactionID ( ) {
		return transactionID;
	}

	/**
	 * Gets the commit flag
	 * 
	 * @return true if the transaction should be committed prior to ending it
	 */
	public final boolean isCommit ( ) {
		return commit;
	}
}
