/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The EndTransactionMessageType is the type of message to be sent to the server to end a started transaction, either committing it or else rolling it back.
 * 
 * @author Erwin Smout
 */
public abstract class EndTransactionMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0xE0D18A55;

	/**
	 * Creates the message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	EndTransactionMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Creates an EndTransaction message corresponding to the version of this message type, holding the given commit flag.
	 * 
	 * @param commit
	 *            true if the transaction to be ended must be committed, false if it is to be rolled back.
	 * @return an EndTransaction message corresponding to the version of this message type, holding the given commit flag.
	 * @deprecated replace with message() invocations including the transaction ID.
	 */
	public final EndTransactionMessage message (boolean commit) {
		return message(commit, -1);
	}

	/**
	 * Creates an EndTransaction message corresponding to the version of this message type, holding the given commit flag and transaction ID.
	 * 
	 * @param commit
	 *            true if the transaction to be ended must be committed, false if it is to be rolled back.
	 * @param transactionID
	 *            The server-side ID of the transaction to be ended. Negative values indicate the "current" transaction, i.e. the lowest transaction in the current nested transaction structure.
	 * @return an EndTransaction message corresponding to the version of this message type, holding the given commit flag.
	 */
	public abstract EndTransactionMessage message (boolean commit, long transactionID);

}
