/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * EndTransactionMessageTypeV1_0 is V1_0 of the EndTransactionMessageType.
 * <p>
 * This message has the following fields :
 * </p>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>COMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction is to be committed, 0 if it is to be rolled back.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class EndTransactionMessageTypeV1_0 extends EndTransactionMessageType {

	/**
	 * the instance
	 */
	private static EndTransactionMessageType instance = new EndTransactionMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static EndTransactionMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private EndTransactionMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == CommitRollbackMessageType.COMMIT);
		return new EndTransactionMessageV1_0(this, commit);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof EndTransactionMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		EndTransactionMessageV1_0 endTransactionMessageV1_0 = (EndTransactionMessageV1_0) message;

		outputStream.writeByte(endTransactionMessageV1_0.isCommit() ? CommitRollbackMessageType.COMMIT : CommitRollbackMessageType.ROLLBACK);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.EndTransactionMessageType#message(boolean, long)
	 */
	@Override
	public EndTransactionMessage message (boolean commit, long transactionID) {
		if (transactionID >= 0) {
			throw new IllegalArgumentException(Messages.getString("EndTransactionMessageTypeV1_0.ServerVersionIncompatibleWithRequest")); //$NON-NLS-1$
		}
		return new EndTransactionMessageV1_0(this, commit);
	}
}
