/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * EndTransactionMessageTypeV1_1 is V1_1 of the EndTransactionMessageType.
 * 
 * <p>
 * This message has the following fields :
 * </p>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>COMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction is to be committed, 0 if it is to be rolled back.</td>
 * </tr>
 * <TR>
 * <TD>TRANSACTIONID</TD>
 * <TD>INTEGER</TD>
 * <TD>8</TD>
 * <TD>The server-side ID of the transaction to be ended.</TD>
 * </TR>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.2
 */
public final class EndTransactionMessageTypeV1_1 extends EndTransactionMessageType {

	/**
	 * the instance
	 */
	private static EndTransactionMessageType instance = new EndTransactionMessageTypeV1_1();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static EndTransactionMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private EndTransactionMessageTypeV1_1 ( ) {
		super(Version.ONE_ONE, Version.ONE_TWO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == CommitRollbackMessageType.COMMIT);
		long transactionID = in.readLong();
		return new EndTransactionMessageV1_1(this, commit, transactionID);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof EndTransactionMessageV1_1)) {
			throw new IllegalArgumentException();
		}

		EndTransactionMessageV1_1 endTransactionMessageV1_1 = (EndTransactionMessageV1_1) message;

		outputStream.writeByte(endTransactionMessageV1_1.isCommit() ? CommitRollbackMessageType.COMMIT : CommitRollbackMessageType.ROLLBACK);
		outputStream.writeLong(endTransactionMessageV1_1.getTransactionID());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.EndTransactionMessageType#message(boolean, long)
	 */
	@Override
	public EndTransactionMessage message (boolean commit, long transactionID) {
		return new EndTransactionMessageV1_1(this, commit, transactionID);
	}
}
