/*
 * Created on 26-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The ErrorMessageType Class encompasses the types of message that are exchanged between SIRA_PRISE clients and servers, and that indicate any kind of error in the processing.
 * 
 * @author Erwin Smout
 */
abstract class ErrorMessageType extends ServerMessageType {

	/**
	 * Creates the instance of some version of this message type
	 * 
	 * @param messageTypeID
	 *            the numeric ID of a particular message type
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            Gets the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	ErrorMessageType (int messageTypeID, Version messageVersion, Version introducedInSiraPriseVersion) {
		super(messageTypeID, messageVersion, introducedInSiraPriseVersion);
	}

}