/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.ServerAssignmentCommand;

/**
 * @author Erwin Smout
 */
public abstract class ExecuteAssignmentMessage extends ServerInputMessage {

	/**
	 * The assignment Commands
	 */
	private ServerAssignmentCommand assignmentCommand;

	/**
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param assignmentCommand
	 *            the assignment Commands
	 */
	ExecuteAssignmentMessage (ExecuteAssignmentMessageType type, ServerAssignmentCommand assignmentCommand) {
		super(type);
		this.assignmentCommand = assignmentCommand;
	}

	/**
	 * Gets the assignment Commands
	 * 
	 * @return the assignment Commands
	 */
	public final ServerAssignmentCommand getAssignmentCommand ( ) {
		return assignmentCommand;
	}

}
