/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.ServerSingleAssignmentCommand;
import be.SIRAPRISE.client.Version;

/**
 * The ExecuteAssignmentMessageType is the message type sent by a client to a server when that client wants to execute some Assignment on the server
 * 
 * @author Erwin Smout
 */
public abstract class ExecuteAssignmentMessageType extends ServerInputMessageType implements ExecuteDMLMessageTypesV14 {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0E5ECA55;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ExecuteAssignmentMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for producing a message of this type holding the given Assignment command
	 * 
	 * @param cmds
	 *            The SIRA_PRISE Assignment commands to be executed as an atomic multiple assignment on the server
	 * @return ExecuteAssignmentMessage
	 */
	public abstract ExecuteAssignmentMessage message (ServerSingleAssignmentCommand[] cmds);

}
