/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.DmlAssertCommand;
import be.SIRAPRISE.client.DmlDeleteCommand;
import be.SIRAPRISE.client.DmlUnassertCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.ServerAddCommand;
import be.SIRAPRISE.client.ServerAssertCommand;
import be.SIRAPRISE.client.ServerAssignmentCommand;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.ServerSingleAssignmentCommand;
import be.SIRAPRISE.client.ServerDeleteCommand;
import be.SIRAPRISE.client.ServerMultipleAssignmentCommand;
import be.SIRAPRISE.client.ServerUnassertCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;

/**
 * ExecuteAssignmentMessageTypeV1_0 is V1_0 of the ExecuteAssignmentMessageType. It implements the new 1.4 way of sending bit-encoded commands to the server, rather than strings.
 * 
 * <P>
 * This message type has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>COUNT</td>
 * <td>INT</td>
 * <td>4</td>
 * <td>The number of 'individual assignments' being carried out.</td>
 * </tr>
 * <tr>
 * <td>ASSIGNMENTS</td>
 * <td>ASSIGNMENT</td>
 * <td>&nbsp;</td>
 * <td>The encoded form of the 'individual assignments' being carried out. Appears as many times as indicated by COUNT.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * <P>
 * The layout for ASSIGNMENT is as follows :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>TYPE</td>
 * <td>INT</td>
 * <td>1</td>
 * <td>The type of 'individual assignments' being carried out. Following values are possible:
 * <ul>
 * <li>1 : ADD</li>
 * <li>2 : DELETE</li>
 * <li>3 : UPDATE</li>
 * <li>5 : ASSERT</li>
 * <li>6 : UNASSERT</li>
 * </ul>
 * </td>
 * </tr>
 * <tr>
 * <td>RELVAR</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the database relvar that is the target of the 'individual assignment'.</td>
 * </tr>
 * <tr>
 * <td>RELATION</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>The formula, in textual form, defining the relation value that will be inserted (ADD/ASSERT) or deleted (DELETE/UNASSERT/UPDATE) from the target relvar.</td>
 * </tr>
 * <tr>
 * <td>UPDATES</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>Only present for the UPDATE assignment type. The formulae, in syntactical form as specified by the grammar, defining the computation of the replacing tuples.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.4
 */
public final class ExecuteAssignmentMessageTypeV1_0 extends ExecuteAssignmentMessageType {

	/**
	 * the instance
	 */
	private static ExecuteAssignmentMessageType instance = new ExecuteAssignmentMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ExecuteAssignmentMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
     */
	private ExecuteAssignmentMessageTypeV1_0 ( ) {
		super(Version.ONE_ONE, Version.ONE_FOUR);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		int count = in.readInt();
		ServerSingleAssignmentCommand[] cmds = new ServerSingleAssignmentCommand[count];
		int i = 0;
		while (i < count) {
			byte assignmentType = in.readByte();
			switch (assignmentType) {
				case DmlAddCommand.ASSIGNMENTTYPE: {
					String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
					String insert = MyDataInputStream.getBigUTFString(in);
					cmds[i] = new ServerAddCommand(targetRelvarName, insert);
				}
					break;
				case DmlDeleteCommand.ASSIGNMENTTYPE: {
					String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
					String delete = MyDataInputStream.getBigUTFString(in);
					cmds[i] = new ServerDeleteCommand(targetRelvarName, delete);
				}
					break;
				case DmlUpdateCommand.ASSIGNMENTTYPE: {
					String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
					String delete = MyDataInputStream.getBigUTFString(in);
					String changes = MyDataInputStream.getBigUTFString(in);
					cmds[i] = new ServerUpdateCommand(targetRelvarName, delete, changes);
				}
					break;
				case DmlAssertCommand.ASSIGNMENTTYPE: {
					String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
					String insert = MyDataInputStream.getBigUTFString(in);
					cmds[i] = new ServerAssertCommand(targetRelvarName, insert);
				}
					break;
				case DmlUnassertCommand.ASSIGNMENTTYPE: {
					String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
					String insert = MyDataInputStream.getBigUTFString(in);
					cmds[i] = new ServerUnassertCommand(targetRelvarName, insert);
				}
					break;
				default:
					throw new IllegalArgumentException();
			}
			i++;
		}
		return new ExecuteAssignmentMessageV1_0(this, count == 1 ? cmds[0] : new ServerMultipleAssignmentCommand(cmds));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ExecuteAssignmentMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		((ExecuteAssignmentMessageV1_0) message).getAssignmentCommand().writeToStream(outputStream);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecuteDMLMessageTypesV14#message(be.SIRAPRISE.client.ServerCommand)
	 */
	@Override
	public ServerMessage message (ServerCommand cmd) {
		return new ExecuteAssignmentMessageV1_0(this, (ServerAssignmentCommand) cmd);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.messages.ExecuteAssignmentMessageType#message(java.lang.String)
	 */
	public ExecuteAssignmentMessageV1_0 message (ServerSingleAssignmentCommand[] cmds) {
		return new ExecuteAssignmentMessageV1_0(this, cmds.length == 1 ? cmds[0] : new ServerMultipleAssignmentCommand(cmds));
	}
}
