/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The ExecuteDMLMessageType is the message type sent by a client to a server when that client wants to execute some DML on the server
 * 
 * @author Erwin Smout
 */
public abstract class ExecuteDMLMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0E5ECD81;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ExecuteDMLMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for producing a message of this type holding the given DML command
	 * 
	 * @param cmd
	 *            The SIRA_PRISE DML command to be executed on the server
	 * @return ExecuteDMLMessage
	 */
	public abstract ExecuteDMLMessage message (String cmd);

}
