/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * ExecuteDMLMessageTypeV1_0 is V1_0 of the ExecuteDMLMessageType.
 * 
 * <P>
 * This message type has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>DMLCOMMAND</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>The command as syntactically defined in the grammar section.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class ExecuteDMLMessageTypeV1_0 extends ExecuteDMLMessageType {

	/**
	 * the instance
	 */
	private static ExecuteDMLMessageTypeV1_0 instance = new ExecuteDMLMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ExecuteDMLMessageTypeV1_0 getInstance ( ) {
		return instance;
	}

	/**
     */
	private ExecuteDMLMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		return new ExecuteDMLMessageV1_0(this, MyDataInputStream.getBigUTFString(in));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ExecuteDMLMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		ExecuteDMLMessageV1_0 executeDMLMessageV1_0 = (ExecuteDMLMessageV1_0) message;
		MyDataOutputStream.writeBigUTF(executeDMLMessageV1_0.getDmlCommand(), outputStream);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.messages.ExecuteDMLMessageType#message(java.lang.String)
	 */
	public ExecuteDMLMessage message (String cmd) {
		return new ExecuteDMLMessageV1_0(this, cmd);
	}
}
