/*
 * Created on 20-aug-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class ExecuteMonitorCommandMessage extends ServerInputMessage {

	/**
	 * the monitor command issued by the user
	 */
	private String monitorCommand;

	/**
	 * the signature authenticating the user ID
	 */
	private byte[] signature;

	/**
	 * Tells whether the user issuing the monitor command has been authenticated by the client
	 */
	private boolean userAuthenticatedByClient;

	/**
	 * The algorithm that can be used by the server to authenticate the user
	 */
	private String userAuthenticationAlgorithm;

	/**
	 * The user ID of the user issuing the monitor command
	 */
	private String userID;

	/**
	 * @param type
	 *            The message type
	 * @param userID
	 *            The user ID of the user issuing the monitor command
	 * @param userAuthenticatedByClient
	 *            Tells whether the user issuing the monitor command has been authenticated by the client
	 * @param userAuthenticationAlgorithm
	 * @param signature
	 *            the signature authenticating the user ID
	 * @param monitorCommand
	 */
	ExecuteMonitorCommandMessage (ExecuteMonitorCommandMessageType type, String userID, boolean userAuthenticatedByClient, String userAuthenticationAlgorithm, byte[] signature, String monitorCommand) {
		super(type);
		this.userID = userID;
		this.userAuthenticatedByClient = userAuthenticatedByClient;
		this.userAuthenticationAlgorithm = userAuthenticationAlgorithm;
		this.signature = signature;
		this.monitorCommand = monitorCommand;
	}

	/**
	 * Gets the monitor command issued by the user
	 * 
	 * @return the monitor command issued by the user
	 */
	public String getMonitorCommand ( ) {
		return monitorCommand;
	}

	/**
	 * Gets the signature authenticating the user ID
	 * 
	 * @return the signature authenticating the user ID
	 */
	public byte[] getSignature ( ) {
		return signature;
	}

	/**
	 * Gets The algorithm that can be used by the server to authenticate the user
	 * 
	 * @return The algorithm that can be used by the server to authenticate the user
	 */
	public String getUserAuthenticationAlgorithm ( ) {
		return userAuthenticationAlgorithm;
	}

	/**
	 * Gets The user ID of the user issuing the monitor command
	 * 
	 * @return The user ID of the user issuing the monitor command
	 */
	public String getUserID ( ) {
		return userID;
	}

	/**
	 * Tells whether the user issuing the monitor command has been authenticated by the client
	 * 
	 * @return true if the user issuing the monitor command has been authenticated by the client
	 */
	public boolean isUserAuthenticatedByClient ( ) {
		return userAuthenticatedByClient;
	}
}
