/*
 * Created on 20-aug-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The ExecuteMonitorCommandMessageType is the type of message sent by a monitor client that wants to execute a monitor command on a SIRA_PRISE server.
 * 
 * @author Erwin Smout
 */
public abstract class ExecuteMonitorCommandMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0E5EC80C;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ExecuteMonitorCommandMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Produces an ExecuteMonitorCommandMessage of the appropriate type reflecting the given attribute values
	 * 
	 * @param monitorCommand
	 *            The monitor command to be executed
	 * @param signature
	 *            The signature authenticating the user ID
	 * @param userAuthenticationAlgorithm
	 *            Name of the Signature algorithm to be used when signing the user ID/verifying the userID signature
	 * @param authenticatedByClient
	 *            true if the user has been authenticated by the client
	 * @param userID
	 *            The ID of the user issuing the monitor command
	 * @return The ExecuteMonitorCommandMessage of the appropriate type reflecting the given attribute values
	 */
	public abstract ExecuteMonitorCommandMessage message (String monitorCommand, byte[] signature, String userAuthenticationAlgorithm, boolean authenticatedByClient, String userID);

}
