/*
 * Created on 20-aug-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * ExecuteMonitorCommandMessageTypeV1_0 is V1_0 of the ExecuteMonitorCommandMessageType.
 * <p>
 * This message has the following fields :
 * </p>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>USERID</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the user issuing the monitor command. Can be the zero-length string, but if not, it must be a name that appears in some tuple of the USER relvar.</td>
 * </tr>
 * <tr>
 * <td>AUTHBYCLIENT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the client has authenticated the user, 0 otherwise.</td>
 * </tr>
 * <tr>
 * <td>AUTHALGORITHM</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the signing algorithm used to compute SIGNATURE. Can be the zero-length string.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURELENGTH</td>
 * <td>INTEGER</td>
 * <td>2</td>
 * <td>The number of bytes in SIGNATURE. Can be zero, in which case the SIGNATURE field is omitted from the message.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURE</td>
 * <td>BYTES</td>
 * <td>&nbsp;</td>
 * <td>The signature as computed by the signature algorithm identified by AUTHALGORITHM, using the user's private key corresponding to the public key that is registered for the user in the USERCERTIFICATE relvar, and applied to the USERID field.</td>
 * </tr>
 * <tr>
 * <td>MONITORCOMMAND</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>The monitor command as syntactically defined in the grammar section.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class ExecuteMonitorCommandMessageTypeV1_0 extends ExecuteMonitorCommandMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new ExecuteMonitorCommandMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private ExecuteMonitorCommandMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		String userID = MyDataInputStream.getSmallUTFString(in);
		boolean authenticatedByClient = (in.readByte() == 1);
		String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
		short signatureLength = in.readShort();
		byte[] signature = new byte[signatureLength];
		in.read(signature);
		String monitorCommand = MyDataInputStream.getBigUTFString(in);

		return new ExecuteMonitorCommandMessageV1_0(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, monitorCommand);
	}

	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ExecuteMonitorCommandMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		ExecuteMonitorCommandMessageV1_0 executeMonitorCommandMessageV1_0 = (ExecuteMonitorCommandMessageV1_0) message;

		MyDataOutputStream.writeSmallUTF(executeMonitorCommandMessageV1_0.getUserID(), outputStream);
		outputStream.write(executeMonitorCommandMessageV1_0.isUserAuthenticatedByClient() ? 1 : 0);
		MyDataOutputStream.writeSmallUTF(executeMonitorCommandMessageV1_0.getUserAuthenticationAlgorithm(), outputStream);
		byte[] signature = executeMonitorCommandMessageV1_0.getSignature();
		outputStream.writeShort(signature.length);
		outputStream.write(signature);
		MyDataOutputStream.writeBigUTF(executeMonitorCommandMessageV1_0.getMonitorCommand(), outputStream);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecuteMonitorCommandMessageType#message()
	 */
	public ExecuteMonitorCommandMessage message (String monitorCommand, byte[] signature, String userAuthenticationAlgorithm, boolean authenticatedByClient, String userID) {
		return new ExecuteMonitorCommandMessageV1_0(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, monitorCommand);
	}
}
