/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.util.List;

/**
 * @author Erwin Smout
 */
public abstract class ExecuteQueryMessage extends ServerInputMessage {

	/**
	 * 
	 */
	private List<String> orderByAttributeNames;

	/**
	 * 
	 */
	private String query;

	/**
	 * Creates the ExecuteQueryMessage
	 * 
	 * @param executeQueryMessageTypeV1_0
	 * @param query
	 * @param orderByAttributeNames
	 */
	ExecuteQueryMessage (ExecuteQueryMessageTypeV1_0 executeQueryMessageTypeV1_0, String query, List<String> orderByAttributeNames) {
		super(executeQueryMessageTypeV1_0);
		this.query = query;
		this.orderByAttributeNames = orderByAttributeNames;
	}

	/**
	 * Gets orderByAttributeNames
	 * 
	 * @return orderByAttributeNames.
	 */
	final List<String> getOrderByAttributeNames ( ) {
		return orderByAttributeNames;
	}

	/**
	 * Gets the assignment Commands
	 * 
	 * @return the assignment Commands
	 */
	public final String getQuery ( ) {
		return query;
	}

}
