/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.util.List;

import be.SIRAPRISE.client.Version;

/**
 * The ExecuteQueryMessageType is the message type sent by a client to a server when that client wants to execute some Query on the server
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.4
 */
public abstract class ExecuteQueryMessageType extends ServerInputMessageType implements ExecuteDMLMessageTypesV14 {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x0E5EC087;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	ExecuteQueryMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for producing a message of this type holding the given Query command
	 * 
	 * @param query
	 *            The SIRA_PRISE Query command to be evaluated by/on the server
	 * @param orderByAttributeNames
	 *            The list of attribute names by which the result is to be ordered. Can be the empty array.
	 * @return ExecuteQueryMessage
	 */
	public abstract ExecuteQueryMessage message (String query, List<String> orderByAttributeNames);

}
