/*
 * Created on 30-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.ServerInquireCommand;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * ExecuteQueryMessageTypeV1_0 is V1_0 of the ExecuteQueryMessageType. It implements the new 1.4 way of sending bit-encoded commands, rather than strings.
 * 
 * <P>
 * This message type has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>QUERY</td>
 * <td>LSTRING</td>
 * <td>&nbsp;</td>
 * <td>The textual representation of the relational expression to be queried, as defined by the grammar.</td>
 * </tr>
 * <tr>
 * <td>ORDERINGS</td>
 * <td>INT</td>
 * <td>4</td>
 * <td>The number of attributes that make up the ordering specification for the result.</td>
 * </tr>
 * <tr>
 * <td>ATTRIBUTENAME</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>Appears as many times as indicated by ORDERINGS.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.4
 */
public final class ExecuteQueryMessageTypeV1_0 extends ExecuteQueryMessageType {

	/**
	 * the instance
	 */
	private static ExecuteQueryMessageType instance = new ExecuteQueryMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ExecuteQueryMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
     */
	private ExecuteQueryMessageTypeV1_0 ( ) {
		super(Version.ONE_ONE, Version.ONE_FOUR);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		String query = MyDataInputStream.getBigUTFString(in);
		int count = in.readInt();
		LinkedList<String> orderByAttributeNames = new LinkedList<String>();
		int i = 0;
		while (i < count) {
			orderByAttributeNames.addLast(MyDataInputStream.getSmallUTFString(in));
		}
		return new ExecuteQueryMessageV1_0(this, query, orderByAttributeNames);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof ExecuteQueryMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		ExecuteQueryMessageV1_0 queryMessage = (ExecuteQueryMessageV1_0) message;
		MyDataOutputStream.writeBigUTF(queryMessage.getQuery(), outputStream);

		List<String> orderByAttributeNames = queryMessage.getOrderByAttributeNames();
		outputStream.writeInt(orderByAttributeNames.size());
		for (String orderByAttributeName : orderByAttributeNames) {
			MyDataOutputStream.writeSmallUTF(orderByAttributeName, outputStream);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecuteDMLMessageTypesV14#message(be.SIRAPRISE.client.ServerCommand)
	 */
	@Override
	public ServerMessage message (ServerCommand cmd) {
		return new ExecuteQueryMessageV1_0(this, cmd.getCommandParametersText(), ((ServerInquireCommand) cmd).getOrderByAttributeNames());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecuteQueryMessageType#message(java.lang.String)
	 */
	@Override
	public ExecuteQueryMessage message (String query, List<String> orderByAttributeNames) {
		return new ExecuteQueryMessageV1_0(this, query, orderByAttributeNames);
	}
}
