/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public abstract class NonSiraPriseErrorMessage extends ServerErrorMessage {

	/**
	 * 
	 */
	private static final String errorClass = Messages.getString("NonSiraPriseErrorMessage.ErrorClassDescription"); //$NON-NLS-1$

	/**
	 * the non SIRA-PRISE exception classname
	 */
	private String className;

	/**
	 * Creates the ErrorMessage object, formatting and setting the appropriate clientResponseText
	 * 
	 * @param type
	 *            The Message Type
	 * @param throwableClassName
	 *            The classname of the Throwable that was thrown in the server operation
	 * @param originalExceptionMessage
	 *            The original exception message from the server
	 * @param fatal
	 *            Flag indicating whether the error was 'fatal', i.e. whether the server has aborted its side of the transaction as a consequence of the error
	 */
	NonSiraPriseErrorMessage (NonSiraPriseErrorMessageType type, String throwableClassName, String originalExceptionMessage, boolean fatal) {
		super(type, -1, MyMessageFormat.format(Messages.getString("NonSiraPriseErrorMessage.DBExceptionMessage"), new String[] { throwableClassName, originalExceptionMessage }), (originalExceptionMessage == null ? throwableClassName : ((originalExceptionMessage.startsWith(throwableClassName) ? "" : (throwableClassName + ':')) + originalExceptionMessage)), fatal); //$NON-NLS-1$ //$NON-NLS-2$
		this.className = throwableClassName;
	}

	/**
	 * Gets the non SIRA-PRISE exception classname
	 * 
	 * @return the non SIRA-PRISE exception classname
	 */
	String getClassName ( ) {
		return className;
	}

	public final String getErrorClass ( ) {
		return errorClass;
	}
}